function M = F2M(F,e)
    
% 函数功能：
%         将真近点角数转化平近点角。

% 输入参数：
% F  -- 真近点角 rad
% e   - 偏心率

% 输出参数：
% M  -- 平近点角 rad

theta=F;
Fr = floor((theta + pi)/(2*pi));
theta = theta - Fr*2*pi;

E = 2*atan2(sqrt(1 - e)*sin(theta/2),sqrt(1 + e)*cos(theta/2));
E = Fr*2*pi + E;

M = E - e*sin(E);

end 