function F = M2F(M,e)

% 函数功能：
%         将平近点角数转化真近点角。

% 输入参数：
% M  -- 平近点角 rad
% e   - 偏心率

% 输出参数：
% F  -- 真近点角 rad


ee=M;                 % ee is eccentric anomaly 
error=0.1;             % initialize accuracy
% Caculate ee on specifying accuracy
while error>1e-10
    eeold=ee;
    ee=M+e*sin(ee);
    error=abs(ee-eeold);
end

E =ee;

Fr = floor((E + pi)/(2*pi));
E = E - Fr*2*pi;

F = 2*atan2(sqrt(1 + e)*sin(E/2),sqrt(1 - e)*cos(E/2));
F = Fr*2*pi + F;
end
