J2 = 1.081874e-3;% 地球带协项系数
Re = 6378.137;%地球半径[km]
mu = 398600.436233;%地球引力常数[km³/s²]

%% 随机生成航天平台的初始轨道
a0 = Re + 500 + 200*rand(1); %轨道高度500km~700km
e0 = 0.001*rand(1);          %偏心率0~0.001
i0 = (65+10*rand(1))*pi/180; %轨道倾角75°~85°
Omega0 = 2*pi*rand(1);       %升交点赤经0°~360°
omega0 = 2*pi*rand(1);       %近地点辐角0°~360°
M0 = 2*pi*rand(1);         %平近点角0°~360°

%% 随机生成航天平台的加速度
fconst = 5e-7+4.5e-6*rand(1);%航天平台恒定加速度5e-7km/s²~5e-6km/s²

%% 随机生成各空间碎片目标
N = randi([100, 200]);%碎片数量150~200
DebrisData = cell(N, 6);
for j = 1:N
    aj = Re + 400 + 400*rand(1);    %轨道高度400km~800km
    ej = 0.001*rand(1);             %偏心率0~0.001
    ij = (60+20*rand(1))*pi/180;    %轨道倾角70°~90°
    Omegaj = 2*pi*rand(1);          %升交点赤经0°~360°
    omegaj = 2*pi*rand(1);          %近地点辐角0°~360°
    M0j = 2*pi*rand(1);             %平近点角0°~360°
    DebrisData(j, :) = {aj, ej, ij, Omegaj, omegaj,M0j};
end

%% 将各参数存储于InitialData.txt
filename = 'InitialData.txt';  
fid = fopen(filename, 'w');
fprintf(fid,'[1] Constants of dynamic environment:\n');
fprintf(fid,'J2 = %.10e\tRe = %.10e\tmu = %.10e\t\n', J2, Re, mu);
fprintf(fid,'[2] Initial elements of platform：\tSMA: %.10e km\tECC: %.10e\tINC: %.10e rad\tRAAN: %.10e rad\tAOP: %.10e rad\tMA: %.10e rad\n', ...
        a0, e0, i0, Omega0, omega0,M0);
fprintf(fid,'[3] Thrust configuration:\n');
fprintf(fid,'Acceleration: %.10e km/s^2\n',fconst);
fprintf(fid,'[4] Number of debris objects： %d\n',N );
fprintf(fid,'[5] Initial COE of debris objects:\n');
fprintf(fid,'Debris_ID\t SMA[km]\t ECC\t INC[rad]\t RAAN[rad]\t AOP[rad]\t MA[rad]\n');
for j = 1:N 
    fprintf(fid,'%d\t', j);
    fprintf(fid,'%.10e\t%.10e\t%.10e\t%.10e\t%.10e\t%.10e\n', DebrisData{j,1}, DebrisData{j,2}, DebrisData{j,3}, DebrisData{j,4}, DebrisData{j,5},DebrisData{j,6});%调换了AOP和RAAN的顺序
end 
fclose(fid);
