function [r,v] = el2rv(el,mu)

% 函数功能：
%         将经典轨道根数转化为位置矢量和速度矢量。

% 输入参数：
% el  -- 经典轨道根数[sma ecc incl OM om theta]
% mu -- 中心天体引力常数，km^3/s^2 
% sma   - 半长轴，单位：km
% ecc   - 偏心率
% incl  - 倾角，单位：弧度
% OM    - 升交点经度，单位：弧度
% om    - 近地点幅角，单位：弧度
% theta - 真近点角，单位：弧度

% 输出参数：
% r  -- 位置矢量，单位为km
% v  -- 速度矢量，单位为km/s 

sma  = el(1);
ecc  = el(2);
incl = el(3);
raan = el(4);
argp = el(5);
theta = el(6);   

% 位置矢量模值和速度矢量模值
nr = sma*(1-ecc*ecc)/(1+ecc*cos(theta));
nv = sqrt(2*mu/nr - mu/sma);

% 航迹角
gamma = atan(ecc*sin(theta)/(1+ecc*cos(theta)));

% 纬度幅角
w = theta + argp;

r = zeros(3,1);
r(1) = nr* (cos(w)*cos(raan) - sin(w)*cos(incl)*sin(raan));
r(2) = nr* (cos(w)*sin(raan) + sin(w)*cos(incl)*cos(raan));
r(3) = nr* (sin(w)*sin(incl));

v = zeros(3,1);
v(1) = nv*( -sin(w - gamma)*cos(raan) - cos(w - gamma)*cos(incl)*sin(raan));
v(2) = nv*( -sin(w - gamma)*sin(raan) + cos(w - gamma)*cos(incl)*cos(raan));
v(3) = nv*(cos(w-gamma)*sin(incl));


end
